
% ！！！！！！！！！！！！！！！
% This code is used in a commercial collaboration project. 
% Please restrict its use to your academic research and do not use it for commercial purposes


clear;
% addpath('/KPCA-MATLAB-master/KernelPCA/')


% Part 1   denoising performance check

load('denosing_check_csi_data.mat');
csi=csi_data;
% This CSI data contains three antennas, one of which has a low SNR. 
% This part is used to check the PCA denoising performance across different dimensions.
% Sampling rate is 200Hz.

    fram0=15000;
    fram1=20000;

 attena1=squeeze(csi(:,1,:));
 attena2=squeeze(csi(:,2,:));

 a1=(attena1(fram0+1:fram1,1:30));
 a2=(attena2(fram0+1:fram1,1:30));
 ratio_a1=abs(a1./a2);

  PCA_reconstruction(ratio_a1);




  %   #########################
 %***************************%
  % Part 2  I/Q PCA denosing + Candidate selection + SSA
  
 load("vital_sign_csi.mat");
 ecg_data=xlsread("vital_sign_ECG.xlsx");


 csi2=csi_data;
%  This CSI data contains vital signs information, e

 fram0=15000;
 fram1=20000;

 attena1=squeeze(csi2(:,1,:));
 attena2=squeeze(csi2(:,2,:));

 a1=(attena1(fram0+1:fram1,1:30));
 a2=(attena2(fram0+1:fram1,1:30));

 ratio_a1=a1./a2;  %ratio method


%  Amplitude and Phase of Raw CSI
 phase_signal=angle(ratio_a1);
 amplitude_signal=abs(ratio_a1);

 I_ratio_a1=real(ratio_a1);
 Q_ratio_a1=imag(ratio_a1);


%|**********************|
%1. kernelPCA denosing
 I_ratio_a1_recon=KernelPCA_reconstruction(I_ratio_a1);
 Q_ratio_a1_recon=KernelPCA_reconstruction(Q_ratio_a1);

 ratio_a1_recon=complex(I_ratio_a1_recon,Q_ratio_a1_recon);

%  Reconstructed Amplitude and Phase patterns
 phase_signal_recon=angle(ratio_a1_recon);
 amplitude_signal_recon=abs(ratio_a1_recon);


 figure(2)
 subplot(2,2,1)
 plot(amplitude_signal(:,1))
 title('Raw CSI amplitude')


 subplot(2,2,2)
 plot(phase_signal(:,1))
 title('Raw CSI phase')


 subplot(2,2,3)
 plot(amplitude_signal_recon(1,:))
 title('Reconstruction CSI amplitude')

 subplot(2,2,4)
 plot(phase_signal_recon(1,:))
 title('Reconstruction CSI phase')
 

%  |*************************| 
%2. Candidate selection
 %% amplitude (30) + phase (30) = signal_set (60)
Singal_Set=[amplitude_signal_recon;phase_signal_recon];

Her_array=zeros(1,60);

signal_length=length(Singal_Set);


for i=1:60
    temp_signal=Singal_Set(i,:);
   [FFTCoeff2,f2]=FFT_Function_2(temp_signal,200);
   bg=int32(1*signal_length/200);
   ed=int32(2*signal_length/200);
   sum_eng=sum(FFTCoeff2(bg:ed));
   all_eng=sum(FFTCoeff2(bg:end));
   en_ratio=sum_eng./all_eng;
   Her_array(i)=en_ratio;
end

    [val,index]=sort(Her_array,'descend');
     max_her=val(1);
     
     idx = find(val > max_her * 0.7);
     val_index = index(idx);
     candidate_signal_array=Singal_Set(val_index,:);



% |*********************|
% 3.SSA 
% The first candidate signal is used as an example.

   x1=candidate_signal_array(1,:);

%3.1 high pass
Fs = 200;              % sample rate
Fc = 0.9;               % (Hz)
order = 5;              %
[b, a] = butter(order, Fc/(Fs/2), 'high');
heartbeat_signal = filtfilt(b, a, x1);

%3.2 SSA
highpass_offset=0;
N=length(heartbeat_signal);

window_length=600; %window size of hankel trajectory matrix  you can change the size by yourself

M=window_length; 
trajectory_matrix = hankel(heartbeat_signal(1:window_length), heartbeat_signal(window_length:end));
Y=trajectory_matrix';
Cemb=Y'*Y / (N-M+1);
C=Cemb;

[RHO,LAMBDA] = eig(C);
LAMBDA = diag(LAMBDA);               % extract the diagonal elements
[LAMBDA,ind]=sort(LAMBDA,'descend'); % sort eigenvalues
RHO = RHO(:,ind); 

r=1;  % select 1st prinpical component
% PC = Y*RHO(:,1:r);
PC = Y*RHO;

RC=zeros(N,M);
for m=1:M
  buf=PC(:,m)*RHO(:,m)'; % invert projection
  buf=buf(end:-1:1,:);
  for n=1:N % anti-diagonal averaging
    RC(n,m)=mean(diag(buf,-(N-M+1)+n) );  
  end
end

signal_SSA = sum(RC(:,1:r),2);



%%%%%3.3 compared with other recovery methods
imfs_emd = emd(heartbeat_signal);           % EMD
signal_EMD=imfs_emd(:,4)';


[imfs_vmd, omega]=vmd(heartbeat_signal);  %VMD
signal_VMD=imfs_emd(:,5)';




figure(3)
DataTitle={'SSA';'VMD';'EMD'};
Data={signal_SSA,signal_VMD,signal_EMD};

csi_time=25;  %25s data for example
csi_xlim = linspace(0, csi_time, N);
 
subplot(4,1,1);

plot(csi_xlim,heartbeat_signal,LineWidth=2);

xticks(0:1:csi_time);
xticklabels(0:1:csi_time);
title('Heartbeat signal without recovery',FontSize=20,Color=[5 80 91]/255);

 yyaxis right


%%%%ecg%%%%%%%  ECG data Sampling rate is 130Hz
len=length(attena1);
ecg=ecg_data(:,3);
st=int32((fram1-fram0)*1.3/2);
ed=int32((len-fram1)*1.3/2);
 x_ecg=ecg(end-ed-st:end-ed);
 ecg_length=length(x_ecg);


 ecg_xlim=(0:1/130:csi_time);

 plot(ecg_xlim,x_ecg,'LineWidth',1);
ylim([-1000 1000]);
ylabel('Amplitude/uV',FontSize=25);


for j=1:3
subplot(4,1,j+1);
cc=Data(j);
tt=cc{1};
plot(csi_xlim,tt(:,1:end),LineWidth=2);

 xticks(0:1:csi_time);
 xticklabels(0:1:csi_time);


set(gca,'FontSize',15);
 box off;

title(['Recovered by ' DataTitle{j}],FontSize=20,Color=[5 80 91]/255);

end

xlabel('Time/s',FontSize=25);
%  yyaxis left
ylabel('Signal mangitude');








function X_recon = PCA_reconstruction(X)

% 1. PCA reconstrcution along the time dimension

    mu = mean(X);
    Xc = X - mu;
    C = cov(Xc);
    [V, D] = eig(C);
    [d, idx] = sort(diag(D), 'descend');
    V = V(:, idx);
    W = V(:,1);
    
    Z = Xc * W;
    % reconstruction
    X_recon_time = Z * W' + mu;


%2. PCA reconstrcution along the subcarrier dimension
    X=X';
    mu = mean(X);
    Xc = X - mu;
    C = cov(Xc);
    [V, D] = eig(C);
    [d, idx] = sort(diag(D), 'descend');
    V = V(:, idx);
    W = V(:,1);
    
    Z = Xc * W;
    % reconstruction
    X_recon_sub = Z * W' + mu;


%3.  PCA reconstrcution along the subcarrier dimension using Kernel PCA
    
      kernel=Kernel('type','gaussian', 'gamma',0.1);
       parameter = struct('numComponents', 1, 'kernelFunc', kernel);
       kpc = KernelPCA(parameter);  
       X_map=kpc.train(X);
       X_recon = kpc.newData;

       figure(1)
       subplot(3,1,1)
       plot(X_recon_time(:,1))
       title("PCA denoising along the CSI time dimension")


       subplot(3,1,2)
       plot(X_recon_sub(1,:))
       title("PCA denoising along the CSI subcarrier dimension")


       subplot(3,1,3)
       plot(X_recon(1,:))
       title('PCA denoising along the CSI subcarrier dimension using Kernel PCA')

     
 end

function X_recon = KernelPCA_reconstruction(X)
 X=X';

 kernel=Kernel('type','gaussian', 'gamma',0.1);
 parameter = struct('numComponents', 1, 'kernelFunc', kernel);
 kpc = KernelPCA(parameter);
 X_map=kpc.train(X);
 X_recon = kpc.newData;

end

function [FFTCoeff,f]=FFT_Function_2(data,fs)

L = length(data); % 信号长度
f = fs*(0:floor(L/2))/L;
Y = fft(data,L);
% FFTCoeff=Y;
P2 = abs(Y/L);
FFTCoeff = 10*P2(1:floor(L/2)+1);%floor是取比它小的整数

end







